const express = require("express");
const router = express.Router();
const staffController = require("../controllers/staffController");
const {
  uploadStaffPhoto,
} = require("../storage/middlewareStorage/uploadStaffMedia");
const authController = require("../controllers/authController");

// ============================================================
// 1. PUBLIC ROUTES (Accessible by anyone)
// ============================================================

router.get("/", staffController.getAllStaff);
router.get("/:id", staffController.getStaffMember);

// ============================================================
// 2. PROTECTED ROUTES (Login Required)
// ============================================================

// All routes below this line require authentication
router.use(authController.protect);

// All routes below this line require Admin or Super-Admin role
router.use(authController.restrictTo("admin", "super-admin"));

router.post("/", uploadStaffPhoto, staffController.createStaff);

router
  .route("/:id")
  .patch(uploadStaffPhoto, staffController.updateStaff)
  .delete(staffController.deleteStaff);

module.exports = router;
